tinymce.PluginManager.add("salintemplate", function (editor, url) {
    editor.ui.registry.addMenuButton("salintemplate", {
        text: "Salin Template",
        fetch: function (callback) {
            var items = [];
            console.log(editor.getElement());
            $.ajax({
                type: "GET",
                url:
                    SITE_URL +
                    "surat_master/salin_template/" + editor.getElement().getAttribute('data-salintemplate'),
                dataType: "json",
                processData: true,
                success: function (response) {
                    $.each(response, function (key, value) {
                        var menuItem = {
                            type: "nestedmenuitem",
                            text: value.nama,
                            getSubmenuItems: function () {
                                return [
                                    {
                                        type: "menuitem",
                                        text: "Template Sistem",
                                        onAction: function () {
                                            setContent(
                                                editor,
                                                value.template.sistem,
                                                "Template Sistem Tidak Tersedia."
                                            );
                                        },
                                    },
                                    {
                                        type: "menuitem",
                                        text: "Template Desa",
                                        onAction: function () {
                                            setContent(
                                                editor,
                                                value.template.desa,
                                                "Template Desa Tidak Tersedia."
                                            );
                                        },
                                    },
                                ];
                            },
                        };

                        items.push(menuItem);
                    });

                    callback(items);
                },

                error: function (xhr, status, error) {
                    notifEditor("Error! " + xhr.status + "\n" + error, "error");
                },
            });
        },
    });
});
