/**
 * plugin.js
 *
 * Copyright, Alberto Peripolli
 * Released under Creative Commons Attribution-NonCommercial 3.0 Unported License.
 *
 * Contributing: https://github.com/trippo/ResponsiveFilemanager
 */

tinymce.PluginManager.add('filemanager', function(editor) {

	editor.file_picker_types = 'file image media';
	editor.file_picker_callback = filemanager;
	let filemanagerData = JSON.parse(editor.getElement().getAttribute('data-filemanager'))
	
	function filemanager_onMessage(event){
		if(filemanagerData.external_filemanager_path.toLowerCase().indexOf(event.origin.toLowerCase()) === 0){
			if(event.data.sender === 'responsivefilemanager'){
				tinymce.activeEditor.windowManager.getParams().setUrl(event.data.url);
				tinymce.activeEditor.windowManager.close();

				// Remove event listener for a message from ResponsiveFilemanager
				if(window.removeEventListener){
					window.removeEventListener('message', filemanager_onMessage, false);
				} else {
					window.detachEvent('onmessage', filemanager_onMessage);
				}
			}
		}
	}

	function filemanager(callback, value, meta) {		
		var width = window.innerWidth-30;
		var height = window.innerHeight-60;
		if(width > 1800) width=1800;
		if(height > 1200) height=1200;
		if(width>600){
			var width_reduce = (width - 20) % 138;
			width = width - width_reduce + 10;
		}

		// DEFAULT AS FILE
		urltype=2;
		if (meta.filetype === 'image' || meta.mediaType === 'image') { urltype=1; }
		if (meta.filetype === 'media' || meta.mediaType === 'media') { urltype=3; }

		var title="RESPONSIVE FileManager";
		if (typeof filemanagerData.filemanager_title !== "undefined" && filemanagerData.filemanager_title) {
			title=filemanagerData.filemanager_title;
		}
		var akey="key";
		if (typeof filemanagerData.filemanager_access_key !== "undefined" && filemanagerData.filemanager_access_key) {
			akey=filemanagerData.filemanager_access_key;
		}
		var sort_by="";
		if (typeof filemanagerData.filemanager_sort_by !== "undefined" && filemanagerData.filemanager_sort_by) {
			sort_by="&sort_by="+filemanagerData.filemanager_sort_by;
		}
		var descending=0;
		if (typeof filemanagerData.filemanager_descending !== "undefined" && filemanagerData.filemanager_descending) {
			descending=filemanagerData.filemanager_descending;
		}
		var fldr="";
		if (typeof filemanagerData.filemanager_subfolder !== "undefined" && filemanagerData.filemanager_subfolder) {
			fldr="&fldr="+filemanagerData.filemanager_subfolder;
		}
		var crossdomain="";
		if (typeof filemanagerData.filemanager_crossdomain !== "undefined" && filemanagerData.filemanager_crossdomain) {
			crossdomain="&crossdomain=1";

			// Add handler for a message from ResponsiveFilemanager
			if(window.addEventListener){
				window.addEventListener('message', filemanager_onMessage, false);
			} else {
				window.attachEvent('onmessage', filemanager_onMessage);
			}
		}

		window.addEventListener('message', function receiveMessage(event) {
			window.removeEventListener('message', receiveMessage, false);
			if (event.data.sender === 'responsivefilemanager') {
				callback(event.data.url);
			}
		}, false);

		var dialogUrl = filemanagerData.external_filemanager_path+'dialog.php?type='+urltype+'&descending='+descending+sort_by+fldr+crossdomain+'&lang='+filemanagerData.language+'&akey='+akey;
		
		if (tinymce.majorVersion > 4) {
			tinymce.activeEditor.windowManager.openUrl({
				title: title,
				url: dialogUrl,
				width: width,
				height: height,
				resizable: true,
				maximizable: true,
				inline: 1,
			});
		} else {
			tinymce.activeEditor.windowManager.open({
				title: title,
				file: dialogUrl,
				width: width,
				height: height,
				resizable: true,
				maximizable: true,
				inline: 1,
			});
		}
	}

	return false;
});
